/*
    Created by Quo
*/
 


INSERT INTO tblQuoDebug 
	(DebugID, 		x_Open, x_Close, 	Message)
VALUES ('Quo_Secrets_Code',	'1',	'0',		'') ;



-- ===============================================================================
-- SECRET AGENDAS
-- This system is still under construction and slated for a possible future release.
-- ===============================================================================


-- Put a limit of 1 on all RandomAgendas
UPDATE RandomAgendas SET GameLimit = 1;


-- For now eliminate the new agendas
UPDATE RandomAgendas SET GameLimit = 0 WHERE AgendaType IN ('AGENDA_CURMUDGEON','AGENDA_FLIRTATIOUS','AGENDA_GOSSIP','AGENDA_SYCOPHANT','AGENDA_SYMPATHIZER') ;


-- Temporary table to use for quick iterations through the various agendas
CREATE TABLE tblQuoSecretRefs(
	AgendaID text PRIMARY KEY
);

-- TODO: Add the new agendas at some point
INSERT INTO tblQuoSecretRefs
		(AgendaID)
VALUES	('AIRPOWER'), 
		('CITY_STATE_ALLY'), 
		('CITY_STATE_PROTECTOR'), 
		('CIVILIZED'), 
		('CULTURED'), 
		('DARWINIST'), 
		('DEVOUT'), 
		('ENVIRONMENTALIST'),
		('EXPLOITATIVE'), 
		('EXPLORER'), 
		('FUN_LOVING'), 
		('GREAT_PERSON_ADVOCATE'), 
		('IDEOLOGUE'), 
		('INDUSTRIALIST'), 
		('MONEY_GRUBBER'), 
		('NUKE_LOVER'), 
		('PARANOID'), 
		('POPULOUS'), 
		('STANDING_ARMY'), 
		('TECHNOPHILE'), 
		('WONDER_ADVOCATE') ;


-- Create a table of clones of the existing Secret Agendas to reference later
CREATE TABLE tblQuoRandomAgendaClones AS 
SELECT * FROM RandomAgendas 
INNER JOIN Agendas ON Agendas.AgendaType= RandomAgendas.AgendaType 
INNER JOIN AgendaTraits ON AgendaTraits.AgendaType = Agendas.AgendaType; 


UPDATE tblQuoDebug SET Message = 'Requirements' WHERE DebugId='Quo_Secrets_Code' ;
		
-- ======================= SECRET REQUIREMENTS ============================		

INSERT INTO Requirements
	(RequirementId, 		RequirementType, 				Likeliness,	Inverse, 	Triggered)
VALUES	('QUO_REQ_SECRET_HAS_CAMPUS', 	'REQUIREMENT_CITY_HAS_DISTRICT',	0,0,0) , 
		('QUO_REQ_SECRET_HAS_AERODROME', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,0,0) ,
		('QUO_REQ_SECRET_HAS_THEATER', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,0,0) ,
		('QUO_REQ_SECRET_HAS_INDUSTRIAL', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,0,0) ,
		('QUO_REQ_SECRET_HAS_COMMERCIAL', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,0,0) ,
		('QUO_REQ_SECRET_HAS_ENTERTAINMENT', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,0,0) ,
		('QUO_REQ_SECRET_HAS_WATERPARK', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,0,0) ,
		('QUO_REQ_SECRET_HAS_ENCAMPMENT', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,0,0) ,
		('QUO_REQ_SECRET_HAS_HARBOR', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,0,0) ,
		('QUO_REQ_SECRET_HAS_NEIGHBORHOOD', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,0,0) ,
		('QUO_REQ_SECRET_HAS_HOLY', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,0,0) ,
		
		('QUO_REQ_SECRET_NOT_HAS_CAMPUS', 	'REQUIREMENT_CITY_HAS_DISTRICT',	0,1,0) , 
		('QUO_REQ_SECRET_NOT_HAS_AERODROME', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,1,0) ,
		('QUO_REQ_SECRET_NOT_HAS_THEATER', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,1,0) ,
		('QUO_REQ_SECRET_NOT_HAS_INDUSTRIAL', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,1,0) ,
		('QUO_REQ_SECRET_NOT_HAS_COMMERCIAL', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,1,0) ,
		('QUO_REQ_SECRET_NOT_HAS_ENTERTAINMENT', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,1,0) ,
		('QUO_REQ_SECRET_NOT_HAS_WATERPARK', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,1,0) ,
		('QUO_REQ_SECRET_NOT_HAS_ENCAMPMENT', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,1,0) ,
		('QUO_REQ_SECRET_NOT_HAS_HARBOR', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,1,0) ,
		('QUO_REQ_SECRET_NOT_HAS_NEIGHBORHOOD', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,1,0) ,
		('QUO_REQ_SECRET_NOT_HAS_HOLY', 		'REQUIREMENT_CITY_HAS_DISTRICT',	0,1,0) ,
		
		
		('QUO_REQ_SECRET_HAS_5_DISTRICTS', 		'REQUIREMENT_CITY_HAS_X_SPECIALTY_DISTRICTS',	0,0,0) ,
		
		('QUO_REQ_SECRET_ADJ_GOVT_DIST', 	'REQUIREMENT_PLOT_ADJACENT_DISTRICT_TYPE_MATCHES',	0,0,0) ,
		
		
		('QUO_REQ_SECRET_NOT_HAS_DENOUNCED_FRIEND', 		'REQUIREMENT_DENOUNCED_FRIEND',	0,1,0) ,
		('QUO_REQ_SECRET_HAS_DENOUNCED_FRIEND', 		'REQUIREMENT_DENOUNCED_FRIEND',	0,0,0) ,
		
		('QUO_REQ_SECRET_PLOT_APPEAL_ENVIRO', 		'REQUIREMENT_PLOT_IS_APPEAL_BETWEEN',	0,0,0) ,
		
		('QUO_REQ_SECRET_NOT_HAS_WONDER', 		'REQUIREMENT_CITY_HAS_ANY_WONDER',	0,0,0) ,
		
		('QUO_REQ_SECRET_MET_1_TURN_AGO', 		'REQUIREMENT_PLAYER_MET_X_TURNS_AGO',	0,0,0) ,
		
		('QUO_REQ_SECRET_AT_WAR', 		'REQUIREMENT_PLAYER_IS_AT_PEACE',	0,1,0) ,
		('QUO_REQ_SECRET_DENOUNCED', 		'REQUIREMENT_DENOUNCED',	0,0,0) ,
		('QUO_REQ_SECRET_DENOUNCED_FRIEND', 		'REQUIREMENT_DENOUNCED_FRIEND',	0,0,0) ,
		
		
		('QUO_REQ_SECRET_DIPLO_VISIBILITY_LVL_2', 		'REQUIREMENT_PLAYER_HAS_AT_LEAST_DIPLO_VIS_LEVEL',	0,0,0) ;
		

			
		
		
INSERT INTO RequirementArguments 
		(RequirementId,			Name, 			Type, 			Value, 		Extra, 	SecondExtra)		
VALUES ('QUO_REQ_SECRET_HAS_HOLY',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_HOLY_SITE',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_HAS_CAMPUS',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_CAMPUS',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_HAS_AERODROME',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_AERODROME',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_HAS_THEATER',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_THEATER',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_HAS_INDUSTRIAL',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_INDUSTRIAL_ZONE',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_HAS_COMMERCIAL',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_COMMERCIAL_HUB',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_HAS_ENCAMPMENT',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_ENCAMPMENT',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_HAS_ENTERTAINMENT',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_ENTERTAINMENT_COMPLEX',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_HAS_WATERPARK',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_WATER_ENTERTAINMENT_COMPLEX',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_HAS_HARBOR',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_HARBOR',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_HAS_NEIGHBORHOOD',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_NEIGHBORHOOD',	NULL,	NULL 	)   ,


		('QUO_REQ_SECRET_NOT_HAS_HOLY',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_HOLY_SITE',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_NOT_HAS_CAMPUS',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_CAMPUS',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_NOT_HAS_AERODROME',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_AERODROME',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_NOT_HAS_THEATER',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_THEATER',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_NOT_HAS_INDUSTRIAL',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_INDUSTRIAL_ZONE',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_NOT_HAS_COMMERCIAL',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_COMMERCIAL_HUB',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_NOT_HAS_ENCAMPMENT',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_ENCAMPMENT',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_NOT_HAS_ENTERTAINMENT',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_ENTERTAINMENT_COMPLEX',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_NOT_HAS_WATERPARK',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_WATER_ENTERTAINMENT_COMPLEX',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_NOT_HAS_HARBOR',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_HARBOR',	NULL,	NULL 	)   ,
		('QUO_REQ_SECRET_NOT_HAS_NEIGHBORHOOD',	'DistrictType',		'ARGTYPE_IDENTITY',	'DISTRICT_NEIGHBORHOOD',	NULL,	NULL 	)   ,
		
		('QUO_REQ_SECRET_ADJ_GOVT_DIST',	'DistrictType',	'ARGTYPE_IDENTITY',	'DISTRICT_GOVERNMENT',	NULL,	NULL 	) ,
		('QUO_REQ_SECRET_ADJ_GOVT_DIST',	'MaxRange',		'ARGTYPE_IDENTITY',		'1',	NULL,	NULL 	) ,
		('QUO_REQ_SECRET_ADJ_GOVT_DIST',	'MinRange',		'ARGTYPE_IDENTITY',		'0',	NULL,	NULL 	) ,
		
		
		('QUO_REQ_SECRET_HAS_5_DISTRICTS',	'Amount',		'ARGTYPE_IDENTITY',	'5',	NULL,	NULL 	)   ,
		
		('QUO_REQ_SECRET_PLOT_APPEAL_ENVIRO',	'MinimumAppeal',		'ARGTYPE_IDENTITY',	'4',	NULL,	NULL 	) ,
		
		
		('QUO_REQ_SECRET_MET_1_TURN_AGO',	'TurnsAgo',		'ARGTYPE_IDENTITY',	'1',	NULL,	NULL 	)  ,
		
		('QUO_REQ_SECRET_DIPLO_VISIBILITY_LVL_2',	'Level',		'ARGTYPE_IDENTITY',	'2',	NULL,	NULL 	)  ;
		
		
		
		
		
INSERT INTO RequirementSets 
	(RequirementSetId, 				RequirementSetType)
VALUES 	('QUO_REQSET_SECRET_HAS_HOLY', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_HAS_CAMPUS', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_HAS_AERODROME', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_HAS_THEATER', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_HAS_INDUSTRIAL', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_HAS_COMMERCIAL', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_HAS_ENCAMPMENT', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_HAS_ENTERTAINMENT', 	'REQUIREMENTSET_TEST_ANY') ,  -- use ANY for Entertainment
		('QUO_REQSET_SECRET_HAS_HARBOR', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_HAS_NEIGHBORHOOD', 	'REQUIREMENTSET_TEST_ALL') ,

		('QUO_REQSET_SECRET_NOT_HAS_HOLY', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_NOT_HAS_CAMPUS', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_NOT_HAS_AERODROME', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_NOT_HAS_THEATER', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_NOT_HAS_INDUSTRIAL', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_NOT_HAS_COMMERCIAL', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_NOT_HAS_ENCAMPMENT', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_NOT_HAS_ENTERTAINMENT', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_NOT_HAS_HARBOR', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_NOT_HAS_NEIGHBORHOOD', 	'REQUIREMENTSET_TEST_ALL') ,
		
		('QUO_REQSET_SECRET_NOT_HAS_WONDER', 	'REQUIREMENTSET_TEST_ALL') ,
		
		('QUO_REQSET_SECRET_ADJ_GOVT_DIST', 	'REQUIREMENTSET_TEST_ALL') ,
		
		('QUO_REQSET_SECRET_PLOT_APPEAL_ENVIRO', 	'REQUIREMENTSET_TEST_ALL') ,
		
		('QUO_REQSET_SECRET_SPOKESPERSON', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_BENIGN', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_DOTARD', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_FUNDAMENTALIST', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_COMRADE', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_BRAGGART', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_WEASEL', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_ACOLYTE', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_APOSTATE', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_ZEALOT', 	'REQUIREMENTSET_TEST_ALL') ,
		('QUO_REQSET_SECRET_WARHAWK', 	'REQUIREMENTSET_TEST_ALL') ;


INSERT INTO RequirementSetRequirements
	(RequirementSetId,	RequirementId)
VALUES	('QUO_REQSET_SECRET_HAS_HOLY', 	'QUO_REQ_SECRET_HAS_HOLY') ,
		('QUO_REQSET_SECRET_HAS_CAMPUS', 	'QUO_REQ_SECRET_HAS_CAMPUS') ,
		('QUO_REQSET_SECRET_HAS_AERODROME', 	'QUO_REQ_SECRET_HAS_AERODROME') ,
		('QUO_REQSET_SECRET_HAS_THEATER', 	'QUO_REQ_SECRET_HAS_THEATER') ,
		('QUO_REQSET_SECRET_HAS_INDUSTRIAL', 	'QUO_REQ_SECRET_HAS_INDUSTRIAL') ,
		('QUO_REQSET_SECRET_HAS_COMMERCIAL', 	'QUO_REQ_SECRET_HAS_COMMERCIAL') ,
		('QUO_REQSET_SECRET_HAS_ENCAMPMENT', 	'QUO_REQ_SECRET_HAS_ENCAMPMENT') ,
		('QUO_REQSET_SECRET_HAS_ENTERTAINMENT', 	'QUO_REQ_SECRET_HAS_ENTERTAINMENT') ,
		('QUO_REQSET_SECRET_HAS_ENTERTAINMENT', 	'QUO_REQ_SECRET_HAS_WATERPARK') ,
		('QUO_REQSET_SECRET_HAS_HARBOR', 	'QUO_REQ_SECRET_HAS_HARBOR') ,
		('QUO_REQSET_SECRET_HAS_NEIGHBORHOOD', 	'QUO_REQ_SECRET_HAS_NEIGHBORHOOD') ,

		('QUO_REQSET_SECRET_NOT_HAS_HOLY', 	'QUO_REQ_SECRET_NOT_HAS_HOLY') ,
		('QUO_REQSET_SECRET_NOT_HAS_CAMPUS', 	'QUO_REQ_SECRET_NOT_HAS_CAMPUS') ,
		('QUO_REQSET_SECRET_NOT_HAS_AERODROME', 	'QUO_REQ_SECRET_NOT_HAS_AERODROME') ,
		('QUO_REQSET_SECRET_NOT_HAS_THEATER', 	'QUO_REQ_SECRET_NOT_HAS_THEATER') ,
		('QUO_REQSET_SECRET_NOT_HAS_INDUSTRIAL', 	'QUO_REQ_SECRET_NOT_HAS_INDUSTRIAL') ,
		('QUO_REQSET_SECRET_NOT_HAS_COMMERCIAL', 	'QUO_REQ_SECRET_NOT_HAS_COMMERCIAL') ,
		('QUO_REQSET_SECRET_NOT_HAS_ENCAMPMENT', 	'QUO_REQ_SECRET_NOT_HAS_ENCAMPMENT') ,
		('QUO_REQSET_SECRET_NOT_HAS_ENTERTAINMENT', 	'QUO_REQ_SECRET_NOT_HAS_ENTERTAINMENT') ,
		('QUO_REQSET_SECRET_NOT_HAS_ENTERTAINMENT', 	'QUO_REQ_SECRET_NOT_HAS_WATERPARK') ,
		('QUO_REQSET_SECRET_NOT_HAS_HARBOR', 	'QUO_REQ_SECRET_NOT_HAS_HARBOR') ,
		('QUO_REQSET_SECRET_NOT_HAS_NEIGHBORHOOD', 	'QUO_REQ_SECRET_NOT_HAS_NEIGHBORHOOD') ,
		
		
		('QUO_REQSET_SECRET_NOT_HAS_WONDER', 	'QUO_REQ_SECRET_NOT_HAS_WONDER') ,

		-- only activate the Not requirements for cities with at least X districts
		('QUO_REQSET_SECRET_NOT_HAS_HOLY', 	'REQUIRES_CITY_HAS_2_SPECIALTY_DISTRICTS') ,
		('QUO_REQSET_SECRET_NOT_HAS_CAMPUS', 	'REQUIRES_CITY_HAS_2_SPECIALTY_DISTRICTS') ,
		('QUO_REQSET_SECRET_NOT_HAS_AERODROME', 	'QUO_REQ_SECRET_HAS_5_DISTRICTS') ,
		('QUO_REQSET_SECRET_NOT_HAS_THEATER', 	'REQUIRES_CITY_HAS_2_SPECIALTY_DISTRICTS') ,
		('QUO_REQSET_SECRET_NOT_HAS_INDUSTRIAL', 	'REQUIRES_CITY_HAS_2_SPECIALTY_DISTRICTS') ,
		('QUO_REQSET_SECRET_NOT_HAS_COMMERCIAL', 	'REQUIRES_CITY_HAS_2_SPECIALTY_DISTRICTS') ,
		('QUO_REQSET_SECRET_NOT_HAS_ENCAMPMENT', 	'REQUIRES_CITY_HAS_2_SPECIALTY_DISTRICTS') ,
		('QUO_REQSET_SECRET_NOT_HAS_ENTERTAINMENT', 	'REQUIRES_CITY_HAS_2_SPECIALTY_DISTRICTS') ,
		('QUO_REQSET_SECRET_NOT_HAS_HARBOR', 	'REQUIRES_CITY_HAS_2_SPECIALTY_DISTRICTS') ,
		('QUO_REQSET_SECRET_NOT_HAS_NEIGHBORHOOD', 	'QUO_REQ_SECRET_HAS_5_DISTRICTS') ,
		
		
		('QUO_REQSET_SECRET_PLOT_APPEAL_ENVIRO', 	'QUO_REQ_SECRET_PLOT_APPEAL_ENVIRO') ,
		
		
		('QUO_REQSET_SECRET_ADJ_GOVT_DIST', 	'QUO_REQ_SECRET_ADJ_GOVT_DIST') ,
		
		
		-- Spokesperson: Player is an ally. Will provide both the Bonus and Malus
		('QUO_REQSET_SECRET_SPOKESPERSON', 	'REQUIRES_PLAYER_ALLY') ,
		--('QUO_REQSET_SECRET_SPOKESPERSON', 	'QUO_REQ_SECRET_DIPLO_VISIBILITY_LVL_2') ,
		
		
		-- Comrade: Player is a friend, and peaceful with neighbors
		('QUO_REQSET_SECRET_COMRADE', 	'REQUIRES_NOT_AT_WAR_WITH_NEIGHBORS') ,		
		('QUO_REQSET_SECRET_COMRADE', 	'REQUIRES_PLAYER_DECLARED_FRIEND') ,
		--('QUO_REQSET_SECRET_COMRADE', 	'QUO_REQ_SECRET_DIPLO_VISIBILITY_LVL_2') ,
		
		
		-- Dotard: Player is at war with this civ, and has the same government
		('QUO_REQSET_SECRET_DOTARD', 	'QUO_REQ_SECRET_AT_WAR') ,
		('QUO_REQSET_SECRET_DOTARD', 	'REQUIRES_HAS_SAME_GOVERNMENT') , 
		('QUO_REQSET_SECRET_DOTARD', 	'REQUIRES_MAJOR_CIV_OPPONENT') , 
		('QUO_REQSET_SECRET_DOTARD', 	'REQUIRES_PLAYERS_HAVE_MET') , 
		--('QUO_REQSET_SECRET_DOTARD', 	'QUO_REQ_SECRET_DIPLO_VISIBILITY_LVL_2') , 
		
		
		-- Weasel: Player is friends with this civ but also at war with a neighbor
		('QUO_REQSET_SECRET_WEASEL', 	'REQUIRES_AT_WAR_WITH_NEIGHBORS') ,
		('QUO_REQSET_SECRET_WEASEL', 	'REQUIRES_PLAYER_DECLARED_FRIEND') ,
		('QUO_REQSET_SECRET_WEASEL', 	'REQUIRES_MAJOR_CIV_OPPONENT') ,
		--('QUO_REQSET_SECRET_WEASEL', 	'QUO_REQ_SECRET_DIPLO_VISIBILITY_LVL_2') ,
		
		
		-- Acolyte: Player is friends and is same religion
		('QUO_REQSET_SECRET_ACOLYTE', 	'REQUIRES_SAME_RELIGION') ,
		('QUO_REQSET_SECRET_ACOLYTE', 	'REQUIRES_PLAYER_DECLARED_FRIEND') ,		
		('QUO_REQSET_SECRET_ACOLYTE', 	'REQUIRES_MAJOR_CIV_OPPONENT') ,		
		--('QUO_REQSET_SECRET_ACOLYTE', 	'QUO_REQ_SECRET_DIPLO_VISIBILITY_LVL_2') ,		
		
		
		-- Fundamentalist
		('QUO_REQSET_SECRET_FUNDAMENTALIST', 	'REQUIRES_SAME_RELIGION') ,
		('QUO_REQSET_SECRET_FUNDAMENTALIST', 	'REQUIRES_PLAYER_HAS_DARK_AGE') ,
		('QUO_REQSET_SECRET_FUNDAMENTALIST', 	'QUO_REQ_SECRET_MET_1_TURN_AGO') ,
		('QUO_REQSET_SECRET_FUNDAMENTALIST', 	'REQUIRES_MAJOR_CIV_OPPONENT') ,
		--('QUO_REQSET_SECRET_FUNDAMENTALIST', 	'QUO_REQ_SECRET_DIPLO_VISIBILITY_LVL_2') ,
		
		
		-- Braggart: Player is in a Dark Age and has open borders with this civ
		('QUO_REQSET_SECRET_BRAGGART', 	'REQUIRES_PLAYER_HAS_DARK_AGE') ,
		('QUO_REQSET_SECRET_BRAGGART', 	'REQUIRES_PLAYER_OPEN_BORDERS') ,
		('QUO_REQSET_SECRET_BRAGGART', 	'REQUIRES_MAJOR_CIV_OPPONENT') ,
		--('QUO_REQSET_SECRET_BRAGGART', 	'QUO_REQ_SECRET_DIPLO_VISIBILITY_LVL_2') ,
		
		
		-- Apostate: Player has not spread his or her religion to this civ
		('QUO_REQSET_SECRET_APOSTATE', 	'REQUIRES_RELIGION_NOT_RECEIVED') ,
		('QUO_REQSET_SECRET_APOSTATE', 	'REQUIRES_PLAYER_DECLARED_FRIEND') ,
		('QUO_REQSET_SECRET_APOSTATE', 	'REQUIRES_MAJOR_CIV_OPPONENT') ,
		--('QUO_REQSET_SECRET_APOSTATE', 	'QUO_REQ_SECRET_DIPLO_VISIBILITY_LVL_2') ;
				
		
		-- Zealot: Player is an ally despite civ's extreme views
		('QUO_REQSET_SECRET_ZEALOT', 	'REQUIRES_PLAYER_ALLY') ,
		('QUO_REQSET_SECRET_ZEALOT', 	'REQUIRES_MAJOR_CIV_OPPONENT') ,
		--('QUO_REQSET_SECRET_ZEALOT', 	'QUO_REQ_SECRET_DIPLO_VISIBILITY_LVL_2') ,
		
		
		-- Warhawk: Player is allied and either you or they are at war
		('QUO_REQSET_SECRET_WARHAWK', 	'REQUIRES_ALLY_IS_AT_WAR')  ,
		('QUO_REQSET_SECRET_WARHAWK', 	'REQUIRES_MAJOR_CIV_OPPONENT')  ;
		--('QUO_REQSET_SECRET_WARHAWK', 	'QUO_REQ_SECRET_DIPLO_VISIBILITY_LVL_2')  ;
		
		


-- BONUSES
UPDATE tblQuoDebug SET Message = 'Bonuses' WHERE DebugId='Quo_Secrets_Code' ;


INSERT INTO Modifiers 
	(ModifierId, ModifierType, RunOnce, Permanent, OwnerRequirementSetId, SubjectRequirementSetId)
VALUES	

	-- airpower gives improved ranged strike
	('QUO_SECRET_AIRPOWER_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_RANGED_STRIKE', 0, 0, NULL, NULL) ,

	-- city state ally provides bonus influence
	('QUO_SECRET_CITY_STATE_ALLY_BONUS', 'MODIFIER_PLAYER_ADJUST_YIELD_CHANGE_PER_TRIBUTARY', 0, 0, NULL, NULL) ,

	-- city state protector provides bonus influence
	('QUO_SECRET_CITY_STATE_PROTECTOR_BONUS', 'MODIFIER_PLAYER_ADJUST_INFLUENCE_POINTS_PER_TURN', 0, 0, NULL, NULL) ,

	-- civilized provides an extra trade route slot
	('QUO_SECRET_CIVILIZED_BONUS', 'MODIFIER_PLAYER_ADJUST_TRADE_ROUTE_CAPACITY', 0, 0, NULL, NULL) ,

	-- cultured provides culture 
	('QUO_SECRET_CULTURED_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_HAS_THEATER') ,

	-- darwinist provides points toward a great general per kill
	('QUO_SECRET_DARWINIST_BONUS', 'MODIFIER_PLAYER_UNITS_ATTACH_MODIFIER', 0, 0, NULL, NULL) ,
	('QUO_SECRET_DARWINIST_BONUS_UNIT', 'MODIFIER_PLAYER_UNIT_ADJUST_GREAT_PEOPLE_POINTS_PER_KILL', 0, 0, NULL, NULL) ,

	-- devout provides combat strength to holy units
	('QUO_SECRET_DEVOUT_BONUS', 'MODIFIER_PLAYER_UNITS_GRANT_ABILITY', 0, 0, NULL, NULL) ,

	-- environmentalist provides bonus faith from camps
	('QUO_SECRET_ENVIRONMENTALIST_BONUS', 'MODIFIER_PLAYER_CITIES_ATTACH_MODIFIER', 0, 0, NULL, NULL) ,
	('QUO_SECRET_ENVIRONMENTALIST_BONUS_CITY', 'MODIFIER_CITY_PLOT_YIELDS_ADJUST_PLOT_YIELD', 0, 0, NULL, 'PLOT_HAS_CAMP_REQUIREMENTS') ,

	-- exploitative provides an additional Builder charge
	('QUO_SECRET_EXPLOITATIVE_BONUS', 'MODIFIER_PLAYER_UNITS_ADJUST_BUILDER_CHARGES', 0, 0, NULL, NULL) ,

	-- explorer provides extra to cities on other continents
	('QUO_SECRET_EXPLORER_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER', 0, 0, NULL, 'CITY_NOT_OWNER_CAPITAL_CONTINENT_REQUIREMENTS') ,

	-- fun loving provides an extra amenity in cities with entertainment
	('QUO_SECRET_FUN_LOVING_BONUS', 'MODIFIER_PLAYER_ADJUST_FREE_RESOURCE_IMPORT', 0, 0, NULL, NULL) ,

	-- great person advocate provides bonus culture from great works
	('QUO_SECRET_GREAT_PERSON_ADVOCATE_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_GREATWORK_YIELD', 0, 0, NULL, NULL) ,

	-- ideologue provides bonus to tiles near the 
	('QUO_SECRET_IDEOLOGUE_BONUS', 'MODIFIER_PLAYER_CITIES_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_ADJ_GOVT_DIST') ,
	('QUO_SECRET_IDEOLOGUE_BONUS_CITY', 'MODIFIER_CITY_PLOT_YIELDS_ADJUST_PLOT_YIELD', 0, 0, NULL, NULL) ,

	-- industrialist provides extra hammers in cities with IZs
	('QUO_SECRET_INDUSTRIALIST_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_HAS_INDUSTRIAL') ,

	-- money grubber provides extra gold in cities with a commercial district
	('QUO_SECRET_MONEY_GRUBBER_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_HAS_COMMERCIAL') ,

	-- nuke lover provides 1 uranium if you have Nuclear Fission tech
	('QUO_SECRET_NUKE_LOVER_BONUS', 'MODIFIER_PLAYER_ADJUST_PLOT_YIELD', 0, 0, NULL, 'PLOT_HAS_STRATEGIC_MINE_REQUIREMENTS') ,

	-- paranoid provides a +1 offensive spy bonus
	('QUO_SECRET_PARANOID_BONUS', 'MODIFIER_PLAYER_ADJUST_SPY_BONUS', 0, 0, NULL, NULL) ,

	-- populous provide additional food in cities with neighborhoods
	('QUO_SECRET_POPULOUS_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_HAS_NEIGHBORHOOD') ,

	-- standing army provides extra production in cities with an encampment
	('QUO_SECRET_STANDING_ARMY_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_HAS_ENCAMPMENT') ,

	-- technophile grants bonus toward eurekas
	('QUO_SECRET_TECHNOPHILE_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_HAS_CAMPUS') ,

	-- wonder advocate 
	('QUO_SECRET_WONDER_ADVOCATE_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_WONDER_PRODUCTION', 0, 0, NULL, NULL) ;


	
INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
VALUES	
		('QUO_SECRET_AIRPOWER_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'12',			NULL, 	NULL) , 

		('QUO_SECRET_CITY_STATE_ALLY_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'10',		NULL, NULL) , 
		('QUO_SECRET_CITY_STATE_ALLY_BONUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'YIELD_GOLD',		NULL, NULL) , 
		
		('QUO_SECRET_CITY_STATE_PROTECTOR_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'3',		NULL, NULL) ,
		
		('QUO_SECRET_CIVILIZED_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 		'1',			NULL, NULL) ,
		
		('QUO_SECRET_CULTURED_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'2',			NULL, 	NULL) ,
		('QUO_SECRET_CULTURED_BONUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'YIELD_CULTURE',			NULL, 	NULL) ,
		
		('QUO_SECRET_DARWINIST_BONUS', 	'ModifierId', 	'ARGTYPE_IDENTITY', 	'QUO_SECRET_DARWINIST_BONUS_UNIT',			NULL, 	NULL) ,
		('QUO_SECRET_DARWINIST_BONUS_UNIT', 	'Amount', 	'ARGTYPE_IDENTITY', 	'2',			NULL, 	NULL) ,
		('QUO_SECRET_DARWINIST_BONUS_UNIT', 	'GreatPersonClassType', 	'ARGTYPE_IDENTITY', 	'GREAT_PERSON_CLASS_GENERAL',			NULL, 	NULL) ,
		
		('QUO_SECRET_DEVOUT_BONUS', 	'AbilityType', 	'ARGTYPE_IDENTITY', 	'ABILITY_RELIGIOUS_ORDERS_BUFF',			NULL, 	NULL) ,
		
		('QUO_SECRET_ENVIRONMENTALIST_BONUS', 	'ModifierType', 	'ARGTYPE_IDENTITY', 	'QUO_SECRET_ENVIRONMENTALIST_BONUS_CITY',		NULL, 	NULL),
		('QUO_SECRET_ENVIRONMENTALIST_BONUS_CITY', 	'Amount', 	'ARGTYPE_IDENTITY', 	'2',			NULL, 	NULL),
		('QUO_SECRET_ENVIRONMENTALIST_BONUS_CITY', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'YIELD_FAITH',			NULL, 	NULL) ,
		
		('QUO_SECRET_EXPLOITATIVE_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'1',			NULL, 	NULL) ,
		
		('QUO_SECRET_EXPLORER_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'10',		NULL, 	NULL) ,
		('QUO_SECRET_EXPLORER_BONUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'YIELD_PRODUCTION',		NULL, 	NULL) ,
		
		('QUO_SECRET_FUN_LOVING_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'1',			NULL, 	NULL) ,
		('QUO_SECRET_FUN_LOVING_BONUS', 	'ResourceType', 	'ARGTYPE_IDENTITY', 	'RESOURCE_TOYS',			NULL, 	NULL) ,
		
		('QUO_SECRET_GREAT_PERSON_ADVOCATE_BONUS', 	'GreatWorkObjectType', 	'ARGTYPE_IDENTITY', 	'GREATWORKOBJECT_WRITING',			NULL, 	NULL) , 
		('QUO_SECRET_GREAT_PERSON_ADVOCATE_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'1',			NULL, 	NULL) , 
		('QUO_SECRET_GREAT_PERSON_ADVOCATE_BONUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'YIELD_CULTURE',			NULL, 	NULL) , 
		
		('QUO_SECRET_IDEOLOGUE_BONUS', 	'ModifierId', 	'ARGTYPE_IDENTITY', 	'QUO_SECRET_IDEOLOGUE_BONUS_CITY',			NULL, 	NULL) ,
		('QUO_SECRET_IDEOLOGUE_BONUS_CITY', 	'Amount', 	'ARGTYPE_IDENTITY', 	'1',			NULL, 	NULL),
		('QUO_SECRET_IDEOLOGUE_BONUS_CITY', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'YIELD_CULTURE',			NULL, 	NULL) ,
		
		('QUO_SECRET_INDUSTRIALIST_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'2',			NULL, 	NULL) , 
		('QUO_SECRET_INDUSTRIALIST_BONUS', 	'YieldType',	 'ARGTYPE_IDENTITY', 	'YIELD_PRODUCTION',	NULL, 	NULL) ,
		
		('QUO_SECRET_MONEY_GRUBBER_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'4',			NULL, 	NULL) , 
		('QUO_SECRET_MONEY_GRUBBER_BONUS', 	'YieldType',	 'ARGTYPE_IDENTITY', 	'YIELD_GOLD',	NULL, 	NULL) ,
		
		('QUO_SECRET_NUKE_LOVER_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'5',			NULL, 	NULL) , 
		('QUO_SECRET_NUKE_LOVER_BONUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'YIELD_SCIENCE',			NULL, 	NULL) , 
		
		('QUO_SECRET_PARANOID_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'1',			NULL, 	NULL) , 
		('QUO_SECRET_PARANOID_BONUS', 	'Offense', 	'ARGTYPE_IDENTITY', 	'1',	NULL, 	NULL) ,
		
		('QUO_SECRET_POPULOUS_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'2',			NULL, 	NULL) , 
		('QUO_SECRET_POPULOUS_BONUS', 	'YieldType',	 'ARGTYPE_IDENTITY', 	'YIELD_FOOD',	NULL, 	NULL) ,
		
		('QUO_SECRET_STANDING_ARMY_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'2',			NULL, 	NULL) , 
		('QUO_SECRET_STANDING_ARMY_BONUS', 	'YieldType',	 'ARGTYPE_IDENTITY', 	'YIELD_FOOD',	NULL, 	NULL) ,
		
		('QUO_SECRET_TECHNOPHILE_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 		'2',			NULL, NULL) ,
		('QUO_SECRET_TECHNOPHILE_BONUS', 	'YieldType',	 'ARGTYPE_IDENTITY', 	'YIELD_SCIENCE',	NULL, 	NULL) ,
		
		('QUO_SECRET_WONDER_ADVOCATE_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 		'10',			NULL, NULL) ;

		

		
		
-- ========================== MALUSES ===============================

UPDATE tblQuoDebug SET Message = 'Maluses' WHERE DebugId='Quo_Secrets_Code' ;


INSERT INTO Modifiers 
	(ModifierId, ModifierType, RunOnce, Permanent, OwnerRequirementSetId, SubjectRequirementSetId)
VALUES	
	-- cities without at least 1 aero have negative production
	('QUO_SECRET_AIRPOWER_MALUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_NOT_HAS_AERODROME') ,

	-- lose identity in city with no governor
	('QUO_SECRET_CITY_STATE_ALLY_MALUS', 'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_TURN', 0, 0, NULL, 'CITY_HAS_NO_GOVERNOR_REQUIREMENTS') ,

	-- lose identity in city with no governor
	('QUO_SECRET_CITY_STATE_PROTECTOR_MALUS', 'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_TURN', 0, 0, NULL, 'CITY_HAS_NO_GOVERNOR_REQUIREMENTS') ,

	-- without a commerce
	('QUO_SECRET_CIVILIZED_MALUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_NOT_HAS_COMMERCIAL') ,

	-- reverses culture
	('QUO_SECRET_CULTURED_MALUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_NOT_HAS_THEATER') ,

	-- without an encampment
	('QUO_SECRET_DARWINIST_MALUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_NOT_HAS_ENCAMPMENT') ,

	-- cities without at least 1 holy site
	('QUO_SECRET_DEVOUT_MALUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_NOT_HAS_HOLY') ,

	-- HAS industrial zone
	('QUO_SECRET_ENVIRONMENTALIST_MALUS', 'MODIFIER_PLAYER_DISTRICTS_ADJUST_YIELD_BASED_ON_APPEAL', 0, 0, NULL, 'QUO_REQSET_SECRET_HAS_INDUSTRIAL') ,

	-- without an industrial zone
	('QUO_SECRET_EXPLOITATIVE_MALUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_NOT_HAS_INDUSTRIAL') ,

	-- without a harbor
	('QUO_SECRET_EXPLORER_MALUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_NOT_HAS_HARBOR') ,

	-- cities without a entertainment plex
	('QUO_SECRET_FUN_LOVING_MALUS', 'MODIFIER_PLAYER_CITIES_ADJUST_POLICY_AMENITY', 0, 0, NULL, 'QUO_REQSET_SECRET_NOT_HAS_ENTERTAINMENT') ,

    -- lose spy offense
	('QUO_SECRET_GREAT_PERSON_ADVOCATE_MALUS', 'MODIFIER_PLAYER_ADJUST_SPY_BONUS', 0, 0, NULL, NULL) ,

	-- lose identity in city with no governor
	('QUO_SECRET_IDEOLOGUE_MALUS', 'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_TURN', 0, 0, NULL, 'CITY_HAS_NO_GOVERNOR_REQUIREMENTS') ,

	-- cities without a production zone
	('QUO_SECRET_INDUSTRIALIST_MALUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_NOT_HAS_INDUSTRIAL') ,

    -- cities without a commerce
	('QUO_SECRET_MONEY_GRUBBER_MALUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_NOT_HAS_COMMERCIAL') ,

	-- without a aerodrome
	('QUO_SECRET_NUKE_LOVER_MALUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_NOT_HAS_AERODROME') ,

	-- lose 1 spy defense
	('QUO_SECRET_PARANOID_MALUS', 'MODIFIER_PLAYER_ADJUST_SPY_BONUS', 0, 0, NULL, NULL) ,
	
	-- cities without a neighborhood
	('QUO_SECRET_POPULOUS_MALUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_NOT_HAS_NEIGHBORHOOD') ,

	-- cities without a encampment
	('QUO_SECRET_STANDING_ARMY_MALUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_NOT_HAS_ENCAMPMENT') ,

	-- reverses science
	('QUO_SECRET_TECHNOPHILE_MALUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_NOT_HAS_CAMPUS') ,

	-- lose production in cities without wonders
	('QUO_SECRET_WONDER_ADVOCATE_MALUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_SECRET_NOT_HAS_WONDER') ;
	
	

	
INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
VALUES	
		('QUO_SECRET_AIRPOWER_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-1',			NULL, 	NULL) , 
		('QUO_SECRET_AIRPOWER_MALUS', 	'YieldType',	 'ARGTYPE_IDENTITY', 	'YIELD_PRODUCTION',	NULL, 	NULL) ,

		('QUO_SECRET_CITY_STATE_ALLY_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-1',		NULL, NULL) , 
		
		('QUO_SECRET_CITY_STATE_PROTECTOR_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-1',		NULL, NULL) ,
		
		('QUO_SECRET_CIVILIZED_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 		'-1',			NULL, NULL) ,
		('QUO_SECRET_CIVILIZED_MALUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 		'YIELD_GOLD',			NULL, NULL) ,
		
		('QUO_SECRET_CULTURED_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-1',			NULL, 	NULL) ,
		('QUO_SECRET_CULTURED_MALUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'YIELD_CULTURE',			NULL, 	NULL) ,
		
		('QUO_SECRET_DARWINIST_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-1',			NULL, 	NULL) ,
		('QUO_SECRET_DARWINIST_MALUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'YIELD_PRODUCTION',			NULL, 	NULL) ,
		
		('QUO_SECRET_DEVOUT_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-1',			NULL, 	NULL) , 
		('QUO_SECRET_DEVOUT_MALUS', 	'YieldType',	 'ARGTYPE_IDENTITY', 	'YIELD_FAITH',	NULL, 	NULL) ,
		
		('QUO_SECRET_ENVIRONMENTALIST_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-1',		NULL, 	NULL),
		('QUO_SECRET_ENVIRONMENTALIST_MALUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'YIELD_FAITH',			NULL, 	NULL) ,
		
		('QUO_SECRET_EXPLOITATIVE_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-1',			NULL, 	NULL) ,
		('QUO_SECRET_EXPLOITATIVE_MALUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'YIELD_PRODUCTION',			NULL, 	NULL) ,
		
		('QUO_SECRET_EXPLORER_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-1',					NULL, 	NULL) ,	
		('QUO_SECRET_EXPLORER_MALUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'YIELD_PRODUCTION',		NULL, 	NULL) ,
		
		('QUO_SECRET_FUN_LOVING_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-1',			NULL, 	NULL) ,
		
		('QUO_SECRET_GREAT_PERSON_ADVOCATE_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-1',			NULL, 	NULL) , 
		('QUO_SECRET_GREAT_PERSON_ADVOCATE_MALUS', 	'Offense', 	'ARGTYPE_IDENTITY', 	'1',	NULL, 	NULL) ,
		
		('QUO_SECRET_IDEOLOGUE_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-1',			NULL, 	NULL) ,
		
		('QUO_SECRET_INDUSTRIALIST_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-1',			NULL, 	NULL) , 
		('QUO_SECRET_INDUSTRIALIST_MALUS', 	'YieldType',	 'ARGTYPE_IDENTITY', 	'YIELD_PRODUCTION',	NULL, 	NULL) ,
		
		('QUO_SECRET_MONEY_GRUBBER_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-1',			NULL, 	NULL) , 
		('QUO_SECRET_MONEY_GRUBBER_MALUS', 	'YieldType',	 'ARGTYPE_IDENTITY', 	'YIELD_GOLD',	NULL, 	NULL) ,
		
		('QUO_SECRET_NUKE_LOVER_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-1',			NULL, 	NULL) ,
		('QUO_SECRET_NUKE_LOVER_MALUS', 	'YieldType',	 'ARGTYPE_IDENTITY', 	'YIELD_GOLD',	NULL, 	NULL) ,		
		
		('QUO_SECRET_PARANOID_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-1',			NULL, 	NULL) , 
		('QUO_SECRET_PARANOID_MALUS', 	'Offense', 	'ARGTYPE_IDENTITY', 	'0',	NULL, 	NULL) ,

		('QUO_SECRET_POPULOUS_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-1',			NULL, 	NULL) , 
		('QUO_SECRET_POPULOUS_MALUS', 	'YieldType',	 'ARGTYPE_IDENTITY', 	'YIELD_FOOD',	NULL, 	NULL) ,
		
		('QUO_SECRET_STANDING_ARMY_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-1',			NULL, 	NULL) , 
		('QUO_SECRET_STANDING_ARMY_MALUS', 	'YieldType',	 'ARGTYPE_IDENTITY', 	'YIELD_FOOD',	NULL, 	NULL) ,
		
		('QUO_SECRET_TECHNOPHILE_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 		'-1',			NULL, NULL) ,
		('QUO_SECRET_TECHNOPHILE_MALUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 		'YIELD_SCIENCE',			NULL, NULL) ,
		
		('QUO_SECRET_WONDER_ADVOCATE_MALUS', 	'Amount', 	'ARGTYPE_IDENTITY', 		'-1',			NULL, NULL) ,
		('QUO_SECRET_WONDER_ADVOCATE_MALUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 		'YIELD_PRODUCTION',			NULL, NULL) ;


		
		
		
		
-- ======================= SECRET FLAVORS ==============================


-- =========================================================
-- BENIGN FLAVOR
-- This is the most basic flavor. Awards the Bonus and Malus if you are Allies.

-- Note this still uses old code from prior to the looping method. Eventually should be scrapped and replaced with a more modern method.
UPDATE tblQuoDebug SET Message = 'Benign Flavor' WHERE DebugId='Quo_Secrets_Code' ;

INSERT INTO Modifiers 
	(ModifierId, ModifierType, RunOnce, Permanent, OwnerRequirementSetId, SubjectRequirementSetId)
VALUES	('QUO_SECRET_AIRPOWER_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_CITY_STATE_ALLY_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_CITY_STATE_PROTECTOR_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_CIVILIZED_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_CULTURED_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_DARWINIST_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_DEVOUT_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_ENVIRONMENTALIST_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_EXPLOITATIVE_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_EXPLORER_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_FUN_LOVING_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_GREAT_PERSON_ADVOCATE_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_IDEOLOGUE_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_INDUSTRIALIST_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_MONEY_GRUBBER_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_NUKE_LOVER_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_PARANOID_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_POPULOUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_STANDING_ARMY_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_TECHNOPHILE_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_WONDER_ADVOCATE_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		
		
		-- maluses
		('QUO_SECRET_AIRPOWER_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_CITY_STATE_ALLY_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_CITY_STATE_PROTECTOR_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_CIVILIZED_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_CULTURED_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_DARWINIST_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_DEVOUT_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_ENVIRONMENTALIST_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_EXPLOITATIVE_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_EXPLORER_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_FUN_LOVING_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_GREAT_PERSON_ADVOCATE_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_IDEOLOGUE_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_INDUSTRIALIST_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_MONEY_GRUBBER_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_NUKE_LOVER_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_PARANOID_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_POPULOUS_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_STANDING_ARMY_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_TECHNOPHILE_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ,
		('QUO_SECRET_WONDER_ADVOCATE_MALUS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_SPOKESPERSON') ;
	

INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
	VALUES ('QUO_SECRET_AIRPOWER_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_AIRPOWER_BONUS',   NULL,  NULL),
		('QUO_SECRET_CITY_STATE_ALLY_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_CITY_STATE_ALLY_BONUS',   NULL,  NULL),
		('QUO_SECRET_CITY_STATE_PROTECTOR_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_CITY_STATE_PROTECTOR_BONUS',   NULL,  NULL),
		('QUO_SECRET_CIVILIZED_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_CIVILIZED_BONUS',   NULL,  NULL),
		('QUO_SECRET_CULTURED_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_CULTURED_BONUS',   NULL,  NULL),
		('QUO_SECRET_DARWINIST_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_DARWINIST_BONUS',   NULL,  NULL),
		('QUO_SECRET_DEVOUT_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_DEVOUT_BONUS',   NULL,  NULL),
		('QUO_SECRET_ENVIRONMENTALIST_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_ENVIRONMENTALIST_BONUS',   NULL,  NULL),
		('QUO_SECRET_EXPLOITATIVE_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_EXPLOITATIVE_BONUS',   NULL,  NULL),
		('QUO_SECRET_EXPLORER_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_EXPLORER_BONUS',   NULL,  NULL),
		('QUO_SECRET_FUN_LOVING_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_FUN_LOVING_BONUS',   NULL,  NULL),
		('QUO_SECRET_GREAT_PERSON_ADVOCATE_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_GREAT_PERSON_ADVOCATE_BONUS',   NULL,  NULL),
		('QUO_SECRET_IDEOLOGUE_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_IDEOLOGUE_BONUS',   NULL,  NULL),
		('QUO_SECRET_INDUSTRIALIST_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_INDUSTRIALIST_BONUS',   NULL,  NULL),
		('QUO_SECRET_MONEY_GRUBBER_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_MONEY_GRUBBER_BONUS',   NULL,  NULL),
		('QUO_SECRET_NUKE_LOVER_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_NUKE_LOVER_BONUS',   NULL,  NULL),
		('QUO_SECRET_PARANOID_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_PARANOID_BONUS',   NULL,  NULL),
		('QUO_SECRET_POPULOUS_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_POPULOUS_BONUS',   NULL,  NULL),
		('QUO_SECRET_STANDING_ARMY_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_STANDING_ARMY_BONUS',   NULL,  NULL),
		('QUO_SECRET_TECHNOPHILE_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_TECHNOPHILE_BONUS',   NULL,  NULL),
		('QUO_SECRET_WONDER_ADVOCATE_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_WONDER_ADVOCATE_BONUS',   NULL,  NULL) ;
		

INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_MALUS_GLOBAL', 'ModifierId', 'ARGTYPE_IDENTITY',  'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_MALUS', NULL, NULL
FROM tblQuoSecretRefs ; 


		
INSERT INTO Types 
	(Type, 					Kind)
VALUES 	('QUO_TRAIT_AGENDA_BENIGN_PREFER_AIRPOWER', 		'KIND_TRAIT'),
	('QUO_TRAIT_AGENDA_BENIGN_CITY_STATE_ALLY', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_CITY_STATE_PROTECTOR', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_CLEAR_BANDIT_CAMPS', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_CULTURE', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_ENJOYS_WAR', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_FAITH', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_ENVIRONMENT', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_EXPLOITATION', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_EXPLORATION_OBSESSED', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_HAPPINESS', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_GREAT_PERSON_ADVOCATE', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_SAME_GOVERNMENT', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_INDUSTRY', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_INCOME', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_NUKES', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_PARANOID', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_POPULATION', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_STANDING_ARMY', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_SCIENCE', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_BENIGN_WONDER_ADVOCATE', 'KIND_TRAIT') ;
	
		
INSERT INTO Traits
	(TraitType, Name, Description, InternalOnly)
VALUES 	('QUO_TRAIT_AGENDA_BENIGN_PREFER_AIRPOWER', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_CITY_STATE_ALLY', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_CITY_STATE_PROTECTOR', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_CLEAR_BANDIT_CAMPS', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_CULTURE', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_ENJOYS_WAR', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_FAITH', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_ENVIRONMENT', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_EXPLOITATION', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_EXPLORATION_OBSESSED', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_HAPPINESS', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_GREAT_PERSON_ADVOCATE', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_SAME_GOVERNMENT', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_INDUSTRY', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_INCOME', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_NUKES', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_PARANOID', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_POPULATION', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_STANDING_ARMY',	'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_SCIENCE', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_BENIGN_WONDER_ADVOCATE',	'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0) ; 
		
		
INSERT INTO TraitModifiers
	(TraitType, 			ModifierID)
VALUES	
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_AIRPOWER', 'QUO_SECRET_AIRPOWER_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_CITY_STATE_ALLY', 'QUO_SECRET_CITY_STATE_ALLY_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_CITY_STATE_PROTECTOR', 'QUO_SECRET_CITY_STATE_PROTECTOR_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_CLEAR_BANDIT_CAMPS', 'QUO_SECRET_CIVILIZED_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_CULTURE', 'QUO_SECRET_CULTURED_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_ENJOYS_WAR', 'QUO_SECRET_DARWINIST_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_FAITH', 'QUO_SECRET_DEVOUT_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_ENVIRONMENT', 'QUO_SECRET_ENVIRONMENTALIST_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_EXPLOITATION', 'QUO_SECRET_EXPLOITATIVE_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_EXPLORATION_OBSESSED', 'QUO_SECRET_EXPLORER_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_HAPPINESS', 'QUO_SECRET_FUN_LOVING_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_GREAT_PERSON_ADVOCATE', 'QUO_SECRET_GREAT_PERSON_ADVOCATE_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_SAME_GOVERNMENT', 'QUO_SECRET_IDEOLOGUE_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_INDUSTRY', 'QUO_SECRET_INDUSTRIALIST_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_INCOME', 'QUO_SECRET_MONEY_GRUBBER_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_NUKES', 'QUO_SECRET_NUKE_LOVER_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PARANOID', 'QUO_SECRET_PARANOID_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_POPULATION', 'QUO_SECRET_POPULOUS_GLOBAL') ,
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_STANDING_ARMY',	'QUO_SECRET_STANDING_ARMY_GLOBAL') ,
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_SCIENCE', 'QUO_SECRET_TECHNOPHILE_GLOBAL') ,
	('QUO_TRAIT_AGENDA_BENIGN_WONDER_ADVOCATE',	'QUO_SECRET_WONDER_ADVOCATE_GLOBAL') ,
	
	-- maluses
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_AIRPOWER', 'QUO_SECRET_AIRPOWER_MALUS_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_CITY_STATE_ALLY', 'QUO_SECRET_CITY_STATE_ALLY_MALUS_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_CITY_STATE_PROTECTOR', 'QUO_SECRET_CITY_STATE_PROTECTOR_MALUS_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_CLEAR_BANDIT_CAMPS', 'QUO_SECRET_CIVILIZED_MALUS_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_CULTURE', 'QUO_SECRET_CULTURED_MALUS_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_ENJOYS_WAR', 'QUO_SECRET_DARWINIST_MALUS_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_FAITH', 'QUO_SECRET_DEVOUT_MALUS_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_ENVIRONMENT', 'QUO_SECRET_ENVIRONMENTALIST_MALUS_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_EXPLOITATION', 'QUO_SECRET_EXPLOITATIVE_MALUS_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_EXPLORATION_OBSESSED', 'QUO_SECRET_EXPLORER_MALUS_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_HAPPINESS', 'QUO_SECRET_FUN_LOVING_MALUS_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_GREAT_PERSON_ADVOCATE', 'QUO_SECRET_GREAT_PERSON_ADVOCATE_MALUS_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_SAME_GOVERNMENT', 'QUO_SECRET_IDEOLOGUE_MALUS_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_INDUSTRY', 'QUO_SECRET_INDUSTRIALIST_MALUS_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_INCOME', 'QUO_SECRET_MONEY_GRUBBER_MALUS_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_NUKES', 'QUO_SECRET_NUKE_LOVER_MALUS_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PARANOID', 'QUO_SECRET_PARANOID_MALUS_GLOBAL'),
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_POPULATION', 'QUO_SECRET_POPULOUS_MALUS_GLOBAL') ,
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_STANDING_ARMY',	'QUO_SECRET_STANDING_ARMY_MALUS_GLOBAL') ,
	('QUO_TRAIT_AGENDA_BENIGN_PREFER_SCIENCE', 'QUO_SECRET_TECHNOPHILE_MALUS_GLOBAL') ,
	('QUO_TRAIT_AGENDA_BENIGN_WONDER_ADVOCATE',	'QUO_SECRET_WONDER_ADVOCATE_MALUS_GLOBAL') ;
	
	
	
	
INSERT INTO AgendaTraits
		(AgendaType, TraitType)
VALUES	('AGENDA_AIRPOWER', 'QUO_TRAIT_AGENDA_BENIGN_PREFER_AIRPOWER') ,
		('AGENDA_CITY_STATE_ALLY', 'QUO_TRAIT_AGENDA_BENIGN_CITY_STATE_ALLY') ,
		('AGENDA_CITY_STATE_PROTECTOR', 'QUO_TRAIT_AGENDA_BENIGN_PREFER_CITY_STATE_PROTECTOR') ,
		('AGENDA_CIVILIZED', 'QUO_TRAIT_AGENDA_BENIGN_PREFER_CLEAR_BANDIT_CAMPS') ,
		('AGENDA_CULTURED', 'QUO_TRAIT_AGENDA_BENIGN_PREFER_CULTURE') ,
		('AGENDA_DARWINIST', 'QUO_TRAIT_AGENDA_BENIGN_ENJOYS_WAR') ,
		('AGENDA_DEVOUT', 'QUO_TRAIT_AGENDA_BENIGN_PREFER_FAITH') ,
		('AGENDA_ENVIRONMENTALIST', 'QUO_TRAIT_AGENDA_BENIGN_PREFER_ENVIRONMENT') ,
		('AGENDA_EXPLOITATIVE', 'QUO_TRAIT_AGENDA_BENIGN_PREFER_EXPLOITATION') ,
		('AGENDA_EXPLORER', 'QUO_TRAIT_AGENDA_BENIGN_EXPLORATION_OBSESSED') ,
		('AGENDA_FUN_LOVING', 'QUO_TRAIT_AGENDA_BENIGN_PREFER_HAPPINESS') ,
		('AGENDA_GREAT_PERSON_ADVOCATE', 'QUO_TRAIT_AGENDA_BENIGN_GREAT_PERSON_ADVOCATE') ,
		('AGENDA_IDEOLOGUE', 'QUO_TRAIT_AGENDA_BENIGN_PREFER_SAME_GOVERNMENT') ,
		('AGENDA_INDUSTRIALIST', 'QUO_TRAIT_AGENDA_BENIGN_PREFER_INDUSTRY') ,
		('AGENDA_MONEY_GRUBBER', 'QUO_TRAIT_AGENDA_BENIGN_PREFER_INCOME') ,
		('AGENDA_NUKE_LOVER', 'QUO_TRAIT_AGENDA_BENIGN_PREFER_NUKES') ,
		('AGENDA_PARANOID', 'QUO_TRAIT_AGENDA_BENIGN_PARANOID') ,
		('AGENDA_POPULOUS', 'QUO_TRAIT_AGENDA_BENIGN_PREFER_POPULATION') ,
		('AGENDA_STANDING_ARMY', 'QUO_TRAIT_AGENDA_BENIGN_PREFER_STANDING_ARMY') ,
		('AGENDA_TECHNOPHILE', 'QUO_TRAIT_AGENDA_BENIGN_PREFER_SCIENCE') ,
		('AGENDA_WONDER_ADVOCATE', 'QUO_TRAIT_AGENDA_BENIGN_WONDER_ADVOCATE') ;

		
		

	
-- =========================================================	
-- DOTARD FLAVOR
-- Receive the Bonus if you Denounce this civ while also having the same government that they do. The target civ can eliminate 
-- the bonus by declaring war, which clears the Denouncement.

UPDATE tblQuoDebug SET Message = 'Dotard Flavor' WHERE DebugId='Quo_Secrets_Code' ;


-- Clone set _DOTARD
INSERT INTO Agendas 
	(AgendaType, OperationList, Name, Description)
SELECT DISTINCT 'QUO_' || tblQuoRandomAgendaClones.AgendaType || '_DOTARD' , NULL, 'LOC_QUO_' || tblQuoRandomAgendaClones.AgendaType || '_DOTARD_NAME', 'LOC_QUO_' || tblQuoRandomAgendaClones.AgendaType || '_DOTARD_DESCRIPTION' 
FROM tblQuoRandomAgendaClones ; 


INSERT INTO RandomAgendas 
	(AgendaType, GameLimit)
SELECT DISTINCT 'QUO_' || tblQuoRandomAgendaClones.AgendaType || '_DOTARD' , tblQuoRandomAgendaClones.GameLimit 
FROM tblQuoRandomAgendaClones ;  

-- Clone basic behavior, such as likes and dislikes, etc
-- Note that unlike previous two selects, this is NOT a DISTINCT selection
INSERT INTO AgendaTraits
	(AgendaType, TraitType)
SELECT  'QUO_' || tblQuoRandomAgendaClones.AgendaType || '_DOTARD', tblQuoRandomAgendaClones.TraitType
FROM  tblQuoRandomAgendaClones ;  


-- simple modifiers for screen verification
INSERT INTO Modifiers 
	(ModifierId, ModifierType, RunOnce, Permanent, OwnerRequirementSetId, SubjectRequirementSetId)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_DOTARD_SIMPLE_DIPLO', 'MODIFIER_PLAYER_DIPLOMACY_SIMPLE_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD' 
FROM tblQuoSecretRefs ;

-- HiddenAgenda
INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_DOTARD_SIMPLE_DIPLO', 'HiddenAgenda', 'ARGTYPE_IDENTITY',  1, NULL, NULL
FROM tblQuoSecretRefs ; 

-- Initial val
INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_DOTARD_SIMPLE_DIPLO', 'InitialValue', 'ARGTYPE_IDENTITY',  -6, NULL, NULL
FROM tblQuoSecretRefs ; 

-- Description
INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_DOTARD_SIMPLE_DIPLO', 'SimpleModifierDescription', 'ARGTYPE_IDENTITY',  'LOC_QUO_SECRET_ANNOYED_DESCRIPTION', NULL, NULL
FROM tblQuoSecretRefs ; 

-- Reason
INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_DOTARD_SIMPLE_DIPLO', 'StatementKey', 'ARGTYPE_IDENTITY',  'LOC_QUO_SECRET_ANNOYED_REASON', NULL, NULL
FROM tblQuoSecretRefs ; 


-- ModifierStrings
INSERT INTO ModifierStrings
	(ModifierId, 			Context, 		Text)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_DOTARD_SIMPLE_DIPLO', 'Sample', 'LOC_TOOLTIP_SAMPLE_DIPLOMACY_ALL'
FROM tblQuoSecretRefs ; 



-- Action Modifiers
INSERT INTO Modifiers 
	(ModifierId, ModifierType, RunOnce, Permanent, OwnerRequirementSetId, SubjectRequirementSetId)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD' 
FROM tblQuoSecretRefs ;
 
/*  INSERT INTO Modifiers 
	(ModifierId, ModifierType, RunOnce, Permanent, OwnerRequirementSetId, SubjectRequirementSetId)
VALUES	('QUO_SECRET_AIRPOWER_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_CITY_STATE_ALLY_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_CITY_STATE_PROTECTOR_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_CIVILIZED_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_CULTURED_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_DARWINIST_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_DEVOUT_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_ENVIRONMENTALIST_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_EXPLOITATIVE_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_EXPLORER_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_FUN_LOVING_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_GREAT_PERSON_ADVOCATE_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_IDEOLOGUE_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_INDUSTRIALIST_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_MONEY_GRUBBER_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_NUKE_LOVER_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_PARANOID_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_POPULOUS_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_STANDING_ARMY_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_TECHNOPHILE_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ,
		('QUO_SECRET_WONDER_ADVOCATE_DOTARD', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_DOTARD') ; */
 	
 
INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_DOTARD', 'ModifierId', 'ARGTYPE_IDENTITY',  'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_BONUS', NULL, NULL
FROM tblQuoSecretRefs ; 
 

/*INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
	VALUES ('QUO_SECRET_AIRPOWER_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_AIRPOWER_BONUS',   NULL,  NULL),
		('QUO_SECRET_CITY_STATE_ALLY_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_CITY_STATE_ALLY_BONUS',   NULL,  NULL),
		('QUO_SECRET_CITY_STATE_PROTECTOR_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_CITY_STATE_PROTECTOR_BONUS',   NULL,  NULL),
		('QUO_SECRET_CIVILIZED_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_CIVILIZED_BONUS',   NULL,  NULL),
		('QUO_SECRET_CULTURED_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_CULTURED_BONUS',   NULL,  NULL),
		('QUO_SECRET_DARWINIST_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_DARWINIST_BONUS',   NULL,  NULL),
		('QUO_SECRET_DEVOUT_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_DEVOUT_BONUS',   NULL,  NULL),
		('QUO_SECRET_ENVIRONMENTALIST_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_ENVIRONMENTALIST_BONUS',   NULL,  NULL),
		('QUO_SECRET_EXPLOITATIVE_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_EXPLOITATIVE_BONUS',   NULL,  NULL),
		('QUO_SECRET_EXPLORER_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_EXPLORER_BONUS',   NULL,  NULL),
		('QUO_SECRET_FUN_LOVING_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_FUN_LOVING_BONUS',   NULL,  NULL),
		('QUO_SECRET_GREAT_PERSON_ADVOCATE_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_GREAT_PERSON_ADVOCATE_BONUS',   NULL,  NULL),
		('QUO_SECRET_IDEOLOGUE_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_IDEOLOGUE_BONUS',   NULL,  NULL),
		('QUO_SECRET_INDUSTRIALIST_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_INDUSTRIALIST_BONUS',   NULL,  NULL),
		('QUO_SECRET_MONEY_GRUBBER_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_MONEY_GRUBBER_BONUS',   NULL,  NULL),
		('QUO_SECRET_NUKE_LOVER_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_NUKE_LOVER_BONUS',   NULL,  NULL),
		('QUO_SECRET_PARANOID_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_PARANOID_BONUS',   NULL,  NULL),
		('QUO_SECRET_POPULOUS_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_POPULOUS_BONUS',   NULL,  NULL),
		('QUO_SECRET_STANDING_ARMY_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_STANDING_ARMY_BONUS',   NULL,  NULL),
		('QUO_SECRET_TECHNOPHILE_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_TECHNOPHILE_BONUS',   NULL,  NULL),
		('QUO_SECRET_WONDER_ADVOCATE_DOTARD',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_SECRET_WONDER_ADVOCATE_BONUS',   NULL,  NULL) ; */

		
INSERT INTO Types
	(Type, 					Kind)
SELECT 'QUO_TRAIT_AGENDA_DOTARD_PREFER_' || tblQuoSecretRefs.AgendaID, 'KIND_TRAIT'
FROM tblQuoSecretRefs ;	
 
 
/* INSERT INTO Types 
	(Type, 					Kind)
VALUES 	('QUO_TRAIT_AGENDA_DOTARD_PREFER_AIRPOWER', 		'KIND_TRAIT'),
	('QUO_TRAIT_AGENDA_DOTARD_CITY_STATE_ALLY', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_CITY_STATE_PROTECTOR', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_CLEAR_BANDIT_CAMPS', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_CULTURE', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_ENJOYS_WAR', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_FAITH', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_ENVIRONMENT', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_EXPLOITATION', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_EXPLORATION_OBSESSED', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_HAPPINESS', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_GREAT_PERSON_ADVOCATE', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_SAME_GOVERNMENT', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_INDUSTRY', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_INCOME', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_NUKES', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_PARANOID', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_POPULATION', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_STANDING_ARMY', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_SCIENCE', 'KIND_TRAIT') ,
	('QUO_TRAIT_AGENDA_DOTARD_WONDER_ADVOCATE', 'KIND_TRAIT') ; */
	
		
INSERT INTO Traits
	(TraitType, Name, Description, InternalOnly)
SELECT 'QUO_TRAIT_AGENDA_DOTARD_PREFER_' || tblQuoSecretRefs.AgendaID, 'LOC_PLACEHOLDER', 'LOC_PLACEHOLDER', 0
FROM tblQuoSecretRefs ;	

		
/* INSERT INTO Traits
	(TraitType, Name, Description, InternalOnly)
VALUES 	('QUO_TRAIT_AGENDA_DOTARD_PREFER_AIRPOWER', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_CITY_STATE_ALLY', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_CITY_STATE_PROTECTOR', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_CLEAR_BANDIT_CAMPS', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_CULTURE', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_ENJOYS_WAR', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_FAITH', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_ENVIRONMENT', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_EXPLOITATION', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_EXPLORATION_OBSESSED', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_HAPPINESS', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_GREAT_PERSON_ADVOCATE', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_SAME_GOVERNMENT', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_INDUSTRY', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_INCOME', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_NUKES', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_PARANOID', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_POPULATION', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_STANDING_ARMY',	'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_SCIENCE', 'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0),
	('QUO_TRAIT_AGENDA_DOTARD_WONDER_ADVOCATE',	'LOC_PLACEHOLDER','LOC_PLACEHOLDER', 0) ;  */
	
	
INSERT INTO TraitModifiers
	(TraitType, 			ModifierID)
SELECT 'QUO_TRAIT_AGENDA_DOTARD_PREFER_' || tblQuoSecretRefs.AgendaID, 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_DOTARD'
FROM tblQuoSecretRefs ;	

-- Add simple diplo modifiers as well
INSERT INTO TraitModifiers
	(TraitType, 			ModifierID)
SELECT 'QUO_TRAIT_AGENDA_DOTARD_PREFER_' || tblQuoSecretRefs.AgendaID, 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_DOTARD_SIMPLE_DIPLO'
FROM tblQuoSecretRefs ;	

	

/* INSERT INTO TraitModifiers
	(TraitType, 			ModifierID)
VALUES	
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_AIRPOWER', 'QUO_SECRET_AIRPOWER_DOTARD'),
	('QUO_TRAIT_AGENDA_DOTARD_CITY_STATE_ALLY', 'QUO_SECRET_CITY_STATE_ALLY_DOTARD'),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_CITY_STATE_PROTECTOR', 'QUO_SECRET_CITY_STATE_PROTECTOR_DOTARD'),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_CLEAR_BANDIT_CAMPS', 'QUO_SECRET_CIVILIZED_DOTARD'),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_CULTURE', 'QUO_SECRET_CULTURED_DOTARD'),
	('QUO_TRAIT_AGENDA_DOTARD_ENJOYS_WAR', 'QUO_SECRET_DARWINIST_DOTARD'),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_FAITH', 'QUO_SECRET_DEVOUT_DOTARD'),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_ENVIRONMENT', 'QUO_SECRET_ENVIRONMENTALIST_DOTARD'),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_EXPLOITATION', 'QUO_SECRET_EXPLOITATIVE_DOTARD'),
	('QUO_TRAIT_AGENDA_DOTARD_EXPLORATION_OBSESSED', 'QUO_SECRET_EXPLORER_DOTARD'),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_HAPPINESS', 'QUO_SECRET_FUN_LOVING_DOTARD'),
	('QUO_TRAIT_AGENDA_DOTARD_GREAT_PERSON_ADVOCATE', 'QUO_SECRET_GREAT_PERSON_ADVOCATE_DOTARD'),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_SAME_GOVERNMENT', 'QUO_SECRET_IDEOLOGUE_DOTARD'),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_INDUSTRY', 'QUO_SECRET_INDUSTRIALIST_DOTARD'),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_INCOME', 'QUO_SECRET_MONEY_GRUBBER_DOTARD'),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_NUKES', 'QUO_SECRET_NUKE_LOVER_DOTARD'),
	('QUO_TRAIT_AGENDA_DOTARD_PARANOID', 'QUO_SECRET_PARANOID_DOTARD'),
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_POPULATION', 'QUO_SECRET_POPULOUS_DOTARD') ,
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_STANDING_ARMY',	'QUO_SECRET_STANDING_ARMY_DOTARD') ,
	('QUO_TRAIT_AGENDA_DOTARD_PREFER_SCIENCE', 'QUO_SECRET_TECHNOPHILE_DOTARD') ,
	('QUO_TRAIT_AGENDA_DOTARD_WONDER_ADVOCATE',	'QUO_SECRET_WONDER_ADVOCATE_DOTARD') ;  */
 
 
INSERT INTO AgendaTraits
	(AgendaType, TraitType)
SELECT 'QUO_AGENDA_' || tblQuoSecretRefs.AgendaID || '_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_PREFER_' || tblQuoSecretRefs.AgendaID
FROM tblQuoSecretRefs ;	
 
 
 
/* INSERT INTO AgendaTraits
		(AgendaType, TraitType)
VALUES	('QUO_AGENDA_AIRPOWER_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_PREFER_AIRPOWER') ,
		('QUO_AGENDA_CITY_STATE_ALLY_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_CITY_STATE_ALLY') ,
		('QUO_AGENDA_CITY_STATE_PROTECTOR_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_PREFER_CITY_STATE_PROTECTOR') ,
		('QUO_AGENDA_CIVILIZED_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_PREFER_CLEAR_BANDIT_CAMPS') ,
		('QUO_AGENDA_CULTURED_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_PREFER_CULTURE') ,
		('QUO_AGENDA_DARWINIST_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_ENJOYS_WAR') ,
		('QUO_AGENDA_DEVOUT_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_PREFER_FAITH') ,
		('QUO_AGENDA_ENVIRONMENTALIST_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_PREFER_ENVIRONMENT') ,
		('QUO_AGENDA_EXPLOITATIVE_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_PREFER_EXPLOITATION') ,
		('QUO_AGENDA_EXPLORER_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_EXPLORATION_OBSESSED') ,
		('QUO_AGENDA_FUN_LOVING_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_PREFER_HAPPINESS') ,
		('QUO_AGENDA_GREAT_PERSON_ADVOCATE_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_GREAT_PERSON_ADVOCATE') ,
		('QUO_AGENDA_IDEOLOGUE_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_PREFER_SAME_GOVERNMENT') ,
		('QUO_AGENDA_INDUSTRIALIST_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_PREFER_INDUSTRY') ,
		('QUO_AGENDA_MONEY_GRUBBER_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_PREFER_INCOME') ,
		('QUO_AGENDA_NUKE_LOVER_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_PREFER_NUKES') ,
		('QUO_AGENDA_PARANOID_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_PARANOID') ,
		('QUO_AGENDA_POPULOUS_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_PREFER_POPULATION') ,
		('QUO_AGENDA_STANDING_ARMY_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_PREFER_STANDING_ARMY') ,
		('QUO_AGENDA_TECHNOPHILE_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_PREFER_SCIENCE') ,
		('QUO_AGENDA_WONDER_ADVOCATE_DOTARD', 'QUO_TRAIT_AGENDA_DOTARD_WONDER_ADVOCATE') ; */
		
		

		
-- =========================================================	
-- COMRADE FLAVOR


UPDATE tblQuoDebug SET Message = 'COMRADE Flavor' WHERE DebugId='Quo_Secrets_Code' ;


-- Clone set _COMRADE
INSERT INTO Agendas 
	(AgendaType, OperationList, Name, Description)
SELECT DISTINCT 'QUO_' || tblQuoRandomAgendaClones.AgendaType || '_COMRADE' , NULL, 'LOC_QUO_' || tblQuoRandomAgendaClones.AgendaType || '_COMRADE_NAME', 'LOC_QUO_' || tblQuoRandomAgendaClones.AgendaType || '_COMRADE_DESCRIPTION' 
FROM tblQuoRandomAgendaClones ; 


INSERT INTO RandomAgendas 
	(AgendaType, GameLimit)
SELECT DISTINCT 'QUO_' || tblQuoRandomAgendaClones.AgendaType || '_COMRADE' , tblQuoRandomAgendaClones.GameLimit 
FROM tblQuoRandomAgendaClones ;  

-- Clone basic behavior, such as likes and dislikes, etc
-- Note that unlike previous two selects, this is NOT a DISTINCT selection
INSERT INTO AgendaTraits
	(AgendaType, TraitType)
SELECT  'QUO_' || tblQuoRandomAgendaClones.AgendaType || '_COMRADE', tblQuoRandomAgendaClones.TraitType
FROM  tblQuoRandomAgendaClones ;  



-- simple modifiers for screen verification
INSERT INTO Modifiers 
	(ModifierId, ModifierType, RunOnce, Permanent, OwnerRequirementSetId, SubjectRequirementSetId)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_COMRADE_SIMPLE_DIPLO', 'MODIFIER_PLAYER_DIPLOMACY_SIMPLE_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_COMRADE' 
FROM tblQuoSecretRefs ;

-- HiddenAgenda
INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_COMRADE_SIMPLE_DIPLO', 'HiddenAgenda', 'ARGTYPE_IDENTITY',  1, NULL, NULL
FROM tblQuoSecretRefs ; 

-- Initial val
INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_COMRADE_SIMPLE_DIPLO', 'InitialValue', 'ARGTYPE_IDENTITY',  2, NULL, NULL
FROM tblQuoSecretRefs ; 

-- Description
INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_COMRADE_SIMPLE_DIPLO', 'SimpleModifierDescription', 'ARGTYPE_IDENTITY',  'LOC_QUO_SECRET_PLEASED_DESCRIPTION', NULL, NULL
FROM tblQuoSecretRefs ; 

-- Reason
INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_COMRADE_SIMPLE_DIPLO', 'StatementKey', 'ARGTYPE_IDENTITY',  'LOC_QUO_SECRET_PLEASED_REASON', NULL, NULL
FROM tblQuoSecretRefs ; 


-- ModifierStrings
INSERT INTO ModifierStrings
	(ModifierId, 			Context, 		Text)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_COMRADE_SIMPLE_DIPLO', 'Sample', 'LOC_TOOLTIP_SAMPLE_DIPLOMACY_ALL'
FROM tblQuoSecretRefs ; 


INSERT INTO Modifiers 
	(ModifierId, ModifierType, RunOnce, Permanent, OwnerRequirementSetId, SubjectRequirementSetId)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_COMRADE', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_COMRADE' 
FROM tblQuoSecretRefs ;
 

 
INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_COMRADE', 'ModifierId', 'ARGTYPE_IDENTITY',  'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_BONUS', NULL, NULL
FROM tblQuoSecretRefs ; 
 

		
INSERT INTO Types
	(Type, 					Kind)
SELECT 'QUO_TRAIT_AGENDA_COMRADE_PREFER_' || tblQuoSecretRefs.AgendaID, 'KIND_TRAIT'
FROM tblQuoSecretRefs ;	
 

		
INSERT INTO Traits
	(TraitType, Name, Description, InternalOnly)
SELECT 'QUO_TRAIT_AGENDA_COMRADE_PREFER_' || tblQuoSecretRefs.AgendaID, 'LOC_PLACEHOLDER', 'LOC_PLACEHOLDER', 0
FROM tblQuoSecretRefs ;	

		
	
INSERT INTO TraitModifiers
	(TraitType, 			ModifierID)
SELECT 'QUO_TRAIT_AGENDA_COMRADE_PREFER_' || tblQuoSecretRefs.AgendaID, 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_COMRADE'
FROM tblQuoSecretRefs ;	
	
 -- Add simple diplo modifiers as well
INSERT INTO TraitModifiers
	(TraitType, 			ModifierID)
SELECT 'QUO_TRAIT_AGENDA_COMRADE_PREFER_' || tblQuoSecretRefs.AgendaID, 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_COMRADE_SIMPLE_DIPLO'
FROM tblQuoSecretRefs ;	


INSERT INTO AgendaTraits
	(AgendaType, TraitType)
SELECT 'QUO_AGENDA_' || tblQuoSecretRefs.AgendaID || '_COMRADE', 'QUO_TRAIT_AGENDA_COMRADE_PREFER_' || tblQuoSecretRefs.AgendaID
FROM tblQuoSecretRefs ;	
 

	

-- =========================================================	
-- WEASEL FLAVOR


UPDATE tblQuoDebug SET Message = 'WEASEL Flavor' WHERE DebugId='Quo_Secrets_Code' ;


-- Clone set _WEASEL
INSERT INTO Agendas 
	(AgendaType, OperationList, Name, Description)
SELECT DISTINCT 'QUO_' || tblQuoRandomAgendaClones.AgendaType || '_WEASEL' , NULL, 'LOC_QUO_' || tblQuoRandomAgendaClones.AgendaType || '_WEASEL_NAME', 'LOC_QUO_' || tblQuoRandomAgendaClones.AgendaType || '_WEASEL_DESCRIPTION' 
FROM tblQuoRandomAgendaClones ; 


INSERT INTO RandomAgendas 
	(AgendaType, GameLimit)
SELECT DISTINCT 'QUO_' || tblQuoRandomAgendaClones.AgendaType || '_WEASEL' , tblQuoRandomAgendaClones.GameLimit 
FROM tblQuoRandomAgendaClones ;  

-- Clone basic behavior, such as likes and dislikes, etc
-- Note that unlike previous two selects, this is NOT a DISTINCT selection
INSERT INTO AgendaTraits
	(AgendaType, TraitType)
SELECT  'QUO_' || tblQuoRandomAgendaClones.AgendaType || '_WEASEL', tblQuoRandomAgendaClones.TraitType
FROM  tblQuoRandomAgendaClones ;  



-- simple modifiers for screen verification
INSERT INTO Modifiers 
	(ModifierId, ModifierType, RunOnce, Permanent, OwnerRequirementSetId, SubjectRequirementSetId)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_WEASEL_SIMPLE_DIPLO', 'MODIFIER_PLAYER_DIPLOMACY_SIMPLE_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_WEASEL' 
FROM tblQuoSecretRefs ;

-- HiddenAgenda
INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_WEASEL_SIMPLE_DIPLO', 'HiddenAgenda', 'ARGTYPE_IDENTITY',  1, NULL, NULL
FROM tblQuoSecretRefs ; 

-- Initial val
INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_WEASEL_SIMPLE_DIPLO', 'InitialValue', 'ARGTYPE_IDENTITY',  2, NULL, NULL
FROM tblQuoSecretRefs ; 

-- Description
INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_WEASEL_SIMPLE_DIPLO', 'SimpleModifierDescription', 'ARGTYPE_IDENTITY',  'LOC_QUO_SECRET_PLEASED_DESCRIPTION', NULL, NULL
FROM tblQuoSecretRefs ; 

-- Reason
INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_WEASEL_SIMPLE_DIPLO', 'StatementKey', 'ARGTYPE_IDENTITY',  'LOC_QUO_SECRET_PLEASED_REASON', NULL, NULL
FROM tblQuoSecretRefs ; 


-- ModifierStrings
INSERT INTO ModifierStrings
	(ModifierId, 			Context, 		Text)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_WEASEL_SIMPLE_DIPLO', 'Sample', 'LOC_TOOLTIP_SAMPLE_DIPLOMACY_ALL'
FROM tblQuoSecretRefs ; 


INSERT INTO Modifiers 
	(ModifierId, ModifierType, RunOnce, Permanent, OwnerRequirementSetId, SubjectRequirementSetId)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_WEASEL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'QUO_REQSET_SECRET_WEASEL' 
FROM tblQuoSecretRefs ;
 

 
INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
SELECT 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_WEASEL', 'ModifierId', 'ARGTYPE_IDENTITY',  'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_BONUS', NULL, NULL
FROM tblQuoSecretRefs ; 
 

		
INSERT INTO Types
	(Type, 					Kind)
SELECT 'QUO_TRAIT_AGENDA_WEASEL_PREFER_' || tblQuoSecretRefs.AgendaID, 'KIND_TRAIT'
FROM tblQuoSecretRefs ;	
 

		
INSERT INTO Traits
	(TraitType, Name, Description, InternalOnly)
SELECT 'QUO_TRAIT_AGENDA_WEASEL_PREFER_' || tblQuoSecretRefs.AgendaID, 'LOC_PLACEHOLDER', 'LOC_PLACEHOLDER', 0
FROM tblQuoSecretRefs ;	

		
	
INSERT INTO TraitModifiers
	(TraitType, 			ModifierID)
SELECT 'QUO_TRAIT_AGENDA_WEASEL_PREFER_' || tblQuoSecretRefs.AgendaID, 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_WEASEL'
FROM tblQuoSecretRefs ;	
	
 -- Add simple diplo modifiers as well
INSERT INTO TraitModifiers
	(TraitType, 			ModifierID)
SELECT 'QUO_TRAIT_AGENDA_WEASEL_PREFER_' || tblQuoSecretRefs.AgendaID, 'QUO_SECRET_' || tblQuoSecretRefs.AgendaID || '_WEASEL_SIMPLE_DIPLO'
FROM tblQuoSecretRefs ;	


INSERT INTO AgendaTraits
	(AgendaType, TraitType)
SELECT 'QUO_AGENDA_' || tblQuoSecretRefs.AgendaID || '_WEASEL', 'QUO_TRAIT_AGENDA_WEASEL_PREFER_' || tblQuoSecretRefs.AgendaID
FROM tblQuoSecretRefs ;	


		
 
 
UPDATE tblQuoDebug SET Message = 'Complete' WHERE DebugId='Quo_Secrets_Code' ;

-- UPDATE BUG TRACKER
-- This code should go last in every file


UPDATE tblQuoDebug SET x_Close='1' WHERE DebugID='Quo_Secrets_Code';